
    SELECT  
        CONCAT(t1.id_solicitacao, t1.numero_procotolo, t8.cnes_estabelecimento) AS identifier_value,
        t2.cns_paciente,
        t2.cpf_paciente,
        CONCAT(DATE_FORMAT(t1.datahora_cadastro, '%Y-%m-%dT%H:%i:%s'), '-03:00') AS data_registro_criado,
        CONCAT(DATE_FORMAT(t1.datahora_analise, '%Y-%m-%dT%H:%i:%s'), '-03:00') AS data_registro_fim,
        t5.id_rnds,
        t9.cns_profissional,
        t7.codigo_cbo,
        t8.cnes_estabelecimento,
        'R69' as CID,
                    IFNULL(
                CASE 
                    WHEN REPLACE(t1.observacao_agendamento, '<br>', '') = '' THEN 'Sem observações'
                    ELSE t1.observacao_agendamento
                END, 
                'Sem observações'
            ) AS observacao_agendamento,
            t3.codigo_sus, 
        CASE
            WHEN t1.id_statussolicitacao = '1' THEN 'PENDENTE'
            WHEN t1.id_statussolicitacao = '2' THEN 'PENDENTE'
            WHEN t1.id_statussolicitacao = '3' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '4' THEN 'AGENDADO'            
            WHEN t1.id_statussolicitacao = '5' THEN 'CANCELADO'
            WHEN t1.id_statussolicitacao = '6' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '7' THEN 'AGENDADO'
            WHEN t1.id_statussolicitacao = '8' THEN 'COMPARECEU'
            WHEN t1.id_statussolicitacao = '9' THEN 'CANCELADO'
            WHEN t1.id_statussolicitacao = '10' THEN 'CANCELADO'
        END AS status_agendamento_2
 FROM
    reg_tb_solicitacoes t1
LEFT JOIN 
    tb_paciente t2 ON t2.id_paciente = t1.id_paciente 
LEFT JOIN 
    reg_tb_procedimento t3 ON t3.id_procedimento = t1.id_procedimento 
LEFT JOIN 
    reg_tb_agendamentos t4 ON t4.id_solicitacao = t1.id_solicitacao 
LEFT JOIN 
    reg_rl_classificacaorisco t5 ON t5.id_classificacaorisco = t1.id_classificacaorisco 
LEFT JOIN 
    reg_tb_agenda t6 ON t6.id_agenda = t4.id_agenda 
LEFT JOIN 
    tb_profissional_vinculo t7 ON t7.codigoprofissional_cnes = t6.codigoprofissional_cnes
LEFT JOIN 
    tb_estabelecimento t8 ON t8.codigoestabelecimento_cnes = t7.codigoestabelecimento_cnes 
LEFT JOIN 
    (SELECT DISTINCT t7.codigoprofissional_cnes, t7.codigo_cbo
     FROM tb_profissional_vinculo t7
     LEFT JOIN reg_tb_agenda t6 ON t7.codigoprofissional_cnes = t6.codigoprofissional_cnes
     WHERE t7.codigo_cbo != '999999') AS subquery_t7 ON t7.codigoprofissional_cnes = subquery_t7.codigoprofissional_cnes
LEFT JOIN 
    tb_profissional t9 ON subquery_t7.codigoprofissional_cnes = t9.codigoprofissional_cnes
    WHERE 
       (t1.id_statussolicitacao = '2' or t4.status_agendamento = 'A' or t1.id_statussolicitacao = '1' or t1.id_statussolicitacao = '5' or t1.id_statussolicitacao = '9' or t1.id_statussolicitacao = '10' or t1.id_statussolicitacao = '6' or t1.id_statussolicitacao = '8')  
    AND t7.codigo_cbo != '999999'
  